"""
Demonstrates the core turtle moves: forward, backward, left, and right.

Open this in IDLE, run the script, and tweak the distances/angles to see
how the turtle travels across the canvas.
"""

import turtle


screen = turtle.Screen()
screen.setup(width=600, height=400)
screen.title("Python Turtle: Basic Movement")

pen = turtle.Turtle()
pen.shape("turtle")
pen.color("seagreen")
pen.pensize(3)

pen.forward(120)  # move to the right
pen.right(90)
pen.forward(70)  # move downward
pen.backward(35)  # go back halfway
pen.left(90)
pen.forward(80)  # finishing step

pen.write("Done!", align="center", font=("Arial", 14, "bold"))

screen.mainloop()

